<?php 

add_action( 'wp_enqueue_scripts', 'salient_child_enqueue_styles', 100);

function salient_child_enqueue_styles() {
		
		$nectar_theme_version = nectar_get_theme_version();
		wp_enqueue_style( 'salient-child-style', get_stylesheet_directory_uri() . '/style.css', '', $nectar_theme_version );
		
    if ( is_rtl() ) {
   		wp_enqueue_style(  'salient-rtl',  get_template_directory_uri(). '/rtl.css', array(), '1', 'screen' );
		}
}
// Removes Order Notes Title - Additional Information & Notes Field
add_filter( 'woocommerce_enable_order_notes_field', '__return_false', 9999 );

// Remove Order Notes Field
add_filter( 'woocommerce_checkout_fields' , 'remove_order_notes' );

function remove_order_notes( $fields ) {
     unset($fields['order']['order_comments']);
     return $fields;
}

/**
 * Add the package booking form  field to the checkout page
 */

add_action( 'woocommerce_before_checkout_billing_form', 'my_custom_checkout_field' );

function my_custom_checkout_field( $checkout ) {
   
   $products_ids_array = array();

foreach( WC()->cart->get_cart() as $cart_item ){
    $products_ids_array[] = $cart_item['product_id'];
}
///print_r($products_ids_array);

if(in_array("3325", $products_ids_array) || in_array("3346", $products_ids_array) || in_array("3347", $products_ids_array)){
    
  /*  echo '<div id="my_custom_checkout_field"><h2>' . __('Package Booking Details') . '</h2>';*/
    
    woocommerce_form_field( 'nameofpet', array(
        'type'          => 'text',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Name of Companion'),
        'required'  => true,
        'placeholder'   => __('Enter Name of Companion'),
        ), $checkout->get_value( 'nameofpet' ));
        
     woocommerce_form_field( 'collectionopt', array(
        'type'          => 'text',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Name of Vet Clinic'),
        'required'  => true,
        'placeholder'   => __('Enter Name of Vet Clinic'),
        ), $checkout->get_value( 'collectionopt' ));
        
    woocommerce_form_field( 'collectionoptadd', array(
        'type'          => 'text',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Vet Clinic Address'),
        'required'  => true,
        'placeholder'   => __('Vet Clinic From Address'),
       
        ), $checkout->get_value( 'collectionoptadd' ));

    woocommerce_form_field( 'vetnum', array(
        'type'          => 'text',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Vet Clinic Contact Number'),
        'required'  => true,
        'placeholder'   => __('Enter Vet Clinic Contact Number'),
       
        ), $checkout->get_value( 'vetnum' ));

        
     woocommerce_form_field( 'weightcat', array(
        'type'          => 'select',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Weight of Companion'),
        'required'  => true,
        'placeholder'   => __('Weight of Companion'),
        'options'	=> array( 
			''		=> 'Please select', // empty values means that field is not selected
			'Mini Companion - Under 2 KG €175', // 'value'=>'Name'
			'Small Companion  2-10 KG €250',
			'Medium Companion  10 -25 KG €300', // 'value'=>'Name'
			'Large Companion 25 - 50 KG €350',
			'Extra Large Companion 50 KG - 75 KG €400', // 'value'=>'Name'
			
			),
        ), $checkout->get_value( 'weightcat' ));  
        
        woocommerce_form_field( 'pickurn', array(
        'type'          => 'select',
        'class'         => array('my-field-class form-row-wide'),
        'label'         => __('Urn / Keepsake choice'),
        'required'  => true,
        'placeholder'   => __('Urn / Keepsake choice'),
        'options'	=> array( 
			''		=> 'Please select', // empty values means that field is not selected
			'Gold', // 'value'=>'Name'
			'Silver',
			'Blonze', // 'value'=>'Name'
			
			),
        ), $checkout->get_value( 'pickurn' ));
        
      
        
    echo '</div>';

    //3-2-21 changes given in file

//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

//add_filter('woocommerce_product_related_posts_query', '__return_empty_array', 100);

    }
    
            }
            
            
//update order meta

add_action('woocommerce_checkout_update_order_meta','my_custom_checkout_field_update_order_meta');
function my_custom_checkout_field_update_order_meta($order_id) {
    
  	if ( ! empty( $_POST['nameofpet'] ) )
        update_post_meta( $order_id, '_nameofpet', $_POST['nameofpet'] );
	
	if ( ! empty( $_POST['collectionopt'] ) )
        update_post_meta( $order_id, '_collectionopt', $_POST['collectionopt'] );
	if ( ! empty( $_POST['collectionoptadd'] ) )
        update_post_meta( $order_id, '_collectionoptadd', $_POST['collectionoptadd'] );
        
	if ( ! empty( $_POST['weightcat'] ) )
        update_post_meta( $order_id, '_weightcat', $_POST['weightcat'] );
        
	if ( ! empty( $_POST['pickurn'] ) )
        update_post_meta( $order_id, '_pickurn', $_POST['pickurn'] );

    if ( ! empty( $_POST['vetnum'] ) )
        update_post_meta( $order_id, '_vetnum', $_POST['vetnum'] );
        
 }
 
 
 // Display fields in the admin and customer e-mails.  
// https://www.tychesoftwares.com/how-to-customize-woocommerce-order-emails/    	      
add_action( 'woocommerce_email_after_order_table', 'ts_email_after_order_table', 10, 4 );
function ts_email_after_order_table( $order, $sent_to_admin, $plain_text, $email ) {
        echo '<h2>Additional information</h2>';
        echo '<p><strong>'.__('Name Of Companion').':</strong> <br/>' . get_post_meta( $order->get_id(), '_nameofpet', true ) . '</p>';
        
	echo '<p><strong>'.__('Name of Vet Clinic').':</strong> <br/>' . get_post_meta( $order->get_id(), '_collectionopt', true ) . '</p>';

    echo '<p><strong>'.__('Vet Clinic Address').':</strong> <br/>' . get_post_meta( $order->get_id(), '_collectionoptadd', true ) . '</p>';
	
	echo '<p><strong>'.__('Vet Clinic Contact Number').':</strong> <br/>' . get_post_meta( $order->get_id(), '_vetnum', true ) . '</p>';
	
	echo '<p><strong>'.__('Weight of Companion').':</strong> <br/>' . get_post_meta( $order->get_id(), '_weightcat', true ) . '</p>';
		
	echo '<p><strong>'.__('Urn / Keepsake choice').':</strong> <br/>' . get_post_meta( $order->get_id(), '_pickurn', true ) . '</p>';
}


//Displaying the custom field on WooCommerce Thank you page
add_filter( 'woocommerce_order_details_after_order_table', 'add_delivery_date_to_order_received_page', 10 , 1 );

function add_delivery_date_to_order_received_page ( $order ) {
	if( version_compare( get_option( 'woocommerce_version' ), '3.0.0', ">=" ) ) {            
        $order_id = $order->get_id();
    } else {
        $order_id = $order->id;
    }
    
    echo "<section class='aditional-info'><h2>Additional Information</h2>";
    
    $nameofpet = get_post_meta( $order_id, '_nameofpet', true );
    if ( '' != $nameofpet ) {
    	echo '<p><strong>' . __( 'Name Of Companion', 'add_extra_fields' ) . ':</strong> ' . $nameofpet;
	}
	
	$collectionopt = get_post_meta( $order_id, '_collectionopt', true );
    if ( '' != $collectionopt ) {
    	echo '<p><strong>' . __( 'Name of Vet Clinic', 'add_extra_fields' ) . ':</strong> ' . $collectionopt;
	}
	
		$collectionoptadd = get_post_meta( $order_id, '_collectionoptadd', true );
    if ( '' != $collectionoptadd ) {
    	echo '<p><strong>' . __( 'Vet Clinic Address', 'add_extra_fields' ) . ':</strong> ' . $collectionoptadd;
	}

        $vatnum = get_post_meta( $order_id, '_vetnum', true );
    if ( '' != $vatnum ) {
        echo '<p><strong>' . __( 'Vet Clinic Contact Number', 'add_extra_fields' ) . ':</strong> ' . $collectionoptadd;
    }
	
	$weightcat = get_post_meta( $order_id, '_weightcat', true );
    if ( '' != $weightcat ) {
    	echo '<p><strong>' . __( 'Weight of Companion', 'add_extra_fields' ) . ':</strong> ' . $weightcat;
	}
	
	$pickurn = get_post_meta( $order_id, '_pickurn', true );
    if ( '' != $pickurn ) {
    	echo '<p><strong>' . __( 'Urn / Keepsake choice', 'add_extra_fields' ) . ':</strong> ' . $pickurn;
	}
	 echo '<section>';
}

//change addto cart to booknow for packages

 
 add_filter( 'woocommerce_product_single_add_to_cart_text', 'woo_custom_cart_button_text' );    // 2.1 +

function woo_custom_cart_button_text( $text ) {
    if( has_term( 'Packages', 'product_cat' ) ){
        $text = __( 'Book Now', 'your-plugin' );
    }
    return $text;
}

//3-2-21 changes given in file
//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
//add_filter('woocommerce_product_related_posts_query', '__return_empty_array', 100);













add_filter( 'wpcf7_contact_form_properties', 'let_me_redirect_to_checkout', 10, 2 );
/**
 * Add the code that will run when on_sent_ok is triggered;
 */
function let_me_redirect_to_checkout( $properties, $contact_form_obj){
 $properties[ 'additional_settings' ] .="on_sent_ok: \"location.replace('https://www.mycompanion.ie/checkout/?add-to-cart=3689');\""
 ;
 return $properties;
}


add_action( 'woocommerce_before_cart_table', 'woo_add_continue_shopping_button_to_cart' );

function woo_add_continue_shopping_button_to_cart() {
 $shop_page_url = get_permalink( woocommerce_get_page_id( 'shop' ) );
 
 echo '<div class="woocommerce-message">';
 echo ' <a href="'.$shop_page_url.'" class="button">Continue Shopping →</a> Would you like some more goods?';
 echo '</div>';
}




function cspd_call_after_for_submit( $contact_form  ){
    $submission = WPCF7_Submission::get_instance();

if ( $submission ) {
    $posted_data = $submission->get_posted_data();
}
    
    $product = $posted_data["products-910"];
    $weight = $posted_data["products-693"];
    global $woocommerce;
$woocommerce->cart->add_to_cart( $product );
$woocommerce->cart->add_to_cart( $weight );
//wp_redirect( get_permalink( 2651 ) );
}

//add_action( 'wpcf7_sent', 'cspd_call_after_for_submit' );

add_action( 'wp_footer', 'redirect_cf7' );
 
function redirect_cf7() {
?>
<script>
document.addEventListener( 'wpcf7mailsent', function( event ) {
        var product = document.getElementById('product-id').value;
        var weight = document.getElementById('weight-id').value;
        var url_full = "https://www.mycompanion.ie/cart/?add-to-cart=" + product + "," + weight;
       location = url_full;
}, false );
</script>
<?php
}



function woocommerce_maybe_add_multiple_products_to_cart() {

if ( ! class_exists( 'WC_Form_Handler' ) || empty( $_REQUEST['add-to-cart'] ) || false === strpos( $_REQUEST['add-to-cart'], ',' ) ) {
    return;
}

$product_ids = explode(',', $_REQUEST['add-to-cart'] );
$count       = count( $product_ids );
$number      = 0;

foreach ( $product_ids as $product_id ) {
    global $woocommerce;
$woocommerce->cart->add_to_cart( $product_id );
    
}
}

 // Fire before the WC_Form_Handler::add_to_cart_action callback.
add_action( 'wp_loaded',        'woocommerce_maybe_add_multiple_products_to_cart', 15 );

